<?php
/**
 * LYB Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package LYB Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_LYB_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'lyb-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_LYB_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

// ----------------------------------------------------------------------------------------------------------
// // Modifications Fabio Bertagnin FBServices juillet 2024
// add_shortcode( 'return_post_id', 'get_the_ID' );
// add_shortcode('return_post_url', 'fbservices_return_post_url');
function fbservices_return_post_url()
{
	$post_id = get_the_ID();
	return get_the_permalink($post_id);
}
// Nécessite le plugin WP Colorbox : https://fr.wordpress.org/plugins/wp-colorbox/
add_shortcode('box_ffas_article_details', 'fbservices_return_box_ffas_article_details');
function fbservices_return_box_ffas_article_details()
{
	$url = fbservices_return_post_url();
	$content = do_shortcode("[wp_colorbox_media url='$url' type='iframe' hyperlink='Plus de détails']");
	return $content;
}